import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/data/models/common_response.dart';
import 'package:razinsoft_rider/data/models/payent_confirm_model/payment_confirm_model.dart';
import 'package:razinsoft_rider/data/repositories/interfaces/payment_confirm_repo_interface.dart';
import 'package:razinsoft_rider/domain/interfaces/payment_confirm_service_interface.dart';

import '../../core/errors/failure.dart';
import 'base_repository.dart';

class PaymentConfirmRepoImpl extends BaseRepository implements IPaymentConfirmRepo {
  final IPaymentConfirmService paymentConfirmService;

  PaymentConfirmRepoImpl({required this.paymentConfirmService});

  @override
  Future<Either<Failure, PaymentConfirmModel>> paymentConfirm({required int orderId, required String paymentMethodName}) async => await safeApiCall(()async{
      final response = await paymentConfirmService.paymentConfirm(orderId: orderId, paymentMethodName: paymentMethodName);
      try {
        return PaymentConfirmModel.fromJson(response.data);
      } catch (e) {
        throw Exception('Parsing error');
      }

    });

  @override
  Future<Either<Failure, CommonResponse>> hitSuccessUrl({required String url}) async => await safeApiCall(()async{
      final response = await paymentConfirmService.hitSuccessUrl(url: url);
      try {
        return CommonResponse.fromMap(response.data);
      } catch (e) {
        throw Exception('Parsing error');
      }

    });

}